// scripts for the ACCESS accommodations part of IARrific - nicktech.org
$j(function() {
    var acc_iep_504 = '';
    var acc_lep = '';
    if ($j('.il_iep:contains("Yes")').length > 0 || $j('.il_504:contains("Yes")').length > 0) {
        var acc_iep_504 = 1;
    } else {
    var acc_iep_504 = 0;
    }
    if ($j('.il_lep:contains("Yes")').length > 0) {
        var acc_lep = 1;
    } else {
    var acc_lep = 0;
    }


    // show hide all of ACCESS
    if (acc_lep === 1 && acc_iep_504 === 1) {
        $j('#access_accommodations').prop('disabled', false);
        $j('#access_disabled_span').hide();
    } else {
        $j('#access_accommodations').prop('disabled', true);
        $j('#access_disabled_span').show();
    }
        
    // when ACCESS is checked unchecked
    $j("#access_accommodations").on('change', function() {
        var stugrade = String($j('.stugrade').text().trim());
        if($j(this).is(':checked')) {
            $j('#access_div').show();
            if (stugrade === 0) {
                $j('#access_mode').val('P');
                $j('#access_alt').prop('disabled', true);
            }
        }
        else if($j(this).prop('checked')===false && $j('#access_div .error-message').is(":visible")) {
            $j('#access_accommodations').prop('checked', true);
            alert('Please correct errors in ACCESS accommodations before unchecking the accommodations checkbox and submitting');
        }
    else {
        $j('#access_div').hide();
    }
    });

    // show paper tier if mode paper
    $j('#access_mode').on('change', function() {
        if ($j(this).val() === 'P') {
            $j('#paper_tier_div').show();
        } else {
            $j('#paper_tier_div').hide();
            $j('#access_paper_tier').val('');
        }
    });
    // large print requires paper
    $j("#access_lp").on('change', function() {
        if ($j(this).prop('checked')===true) {
            $j('#access_mode').val('P');
            $j('#paper_tier_div').show();
        }
    });
    // alt test access mode should be blank
    $j("#access_alt").on('change', function() {
        if ($j(this).prop('checked')===true) {
            $j('#access_mode').val('');
            $j('#paper_tier_div').hide();
            $j('#access_lv').prop('checked', false);
            $j('#access_lv_div').hide();
        } else {
            $j('#paper_tier_div').show();
            $j('#access_lv_div').show();
        }
    });
    // braille requires paper
    $j('#access_br').on('change', function() {
        if ($j(this).val() !== '') {
            $j('#access_mode').val('P');
            $j('#paper_tier_div').show();
        }
    });

    $j("#access_mode, #access_accommodations, #access_alt").trigger('change');
});

// runs at page submit to clear fields if their containing div is hidden and check paper tier
  function clear_access() {
	if($j("#access_accommodations").prop('checked')===false){
		$j("#access_div").children().find("input,select").each(function(){
   			$j(this).val('');
		});
	}
    if ($j('#access_mode').val() === 'P' && $j('#access_paper_tier').val() === '' && $j("#access_alt").prop('checked')===false) {
        alert('ACCESS Paper Tier is required when mode is Paper, and Alt Access is not checked');
        return false;
    }
  }
$j('#myform').submit(clear_access);

