// scripts for IARrific - nicktech.org

// Reorder TDs alphabetically
document.addEventListener("DOMContentLoaded", function () {

    function normalizeText(text) {
        return text.replace(/\s+/g, " ").trim().toLowerCase();
    }

    function sortAccommodationTable(table) {
        var tbody = table.tBodies[0] || table;
        var rows = Array.prototype.slice.call(tbody.rows);
        var pairs = [];

        // Extract TD pairs (label + control)
        for (var i = 0; i < rows.length; i++) {
            var cells = rows[i].cells;

            for (var j = 0; j < cells.length; j += 2) {
                if (cells[j] && cells[j + 1]) {
                    pairs.push({
                        labelText: normalizeText(cells[j].textContent),
                        labelHTML: cells[j].outerHTML,
                        controlHTML: cells[j + 1].outerHTML
                    });
                }
            }
        }

        // Sort alphabetically by visible label text
        pairs.sort(function (a, b) {
            if (a.labelText < b.labelText) return -1;
            if (a.labelText > b.labelText) return 1;
            return 0;
        });

        // Clear table
        while (tbody.firstChild) {
            tbody.removeChild(tbody.firstChild);
        }

        // Rebuild rows, 2 items per row (4 TDs)
        for (var k = 0; k < pairs.length; k += 2) {
            var tr = document.createElement("tr");

            tr.innerHTML += pairs[k].labelHTML + pairs[k].controlHTML;

            if (pairs[k + 1]) {
                tr.innerHTML += pairs[k + 1].labelHTML + pairs[k + 1].controlHTML;
            }

            tbody.appendChild(tr);
        }
    }

    // Apply to all accommodation tables
    var tables = document.querySelectorAll("table.IARsubjectTable");
    for (var t = 0; t < tables.length; t++) {
        sortAccommodationTable(tables[t]);
    }

});

function determineForm() {
    var ela_form = 'Online Regular';
    var math_form = 'Online Regular';
    var science_form = 'Online Regular';
    // ELA
    if(!$j('#ela_accommodations').is(':checked')) {
        if($j('#PARCC_ELA_Test_Format').val() === 'P'){
            ela_form = 'Paper Regular';
        }
    }
    else {
        if($j('#PARCC_ELA_Test_Format').val() === 'P') {
            if($j('#PARCC_ELA_Braille_W_Graphic_yes').is(':checked')){
                ela_form = 'Paper Braille';
            } else 
            if($j('#PARCC_ELA_Large_Print_yes').is(':checked')){
                ela_form = 'Paper Large Print';
            } else {
                ela_form = 'Paper Regular';
            }
        } else {
            if($j('#PARCC_ELA_sign_language_yes').is(':checked')){
                ela_form = 'Online Accommodated - Sign Language';
            } else 
            if($j('#PARCC_ELA_Screen_Reader_App').val() || $j('#PARCC_ELA_Braille_Response_yes').is(':checked')){
                ela_form = 'Online Accommodated - AT/Screen Reader';
            } else 
            if($j('#PARCC_ELA_Text_To_Speech_yes').is(':checked') || $j('#PARCC_ELA_Human_Reader').val()){
                ela_form = 'Online Accommodated - Bundle';
            }

            if($j('#ELA_Extensions_yes').is(':checked')) {
                ela_form += ' + Speech to Text and Word Prediction';
            }
            if($j('#PARCC_ELA_Color_Contrast').val() === '01') {
                ela_form += ' + Extra Large Mouse Cursor Black';
            }
            if($j('#PARCC_ELA_Color_Contrast').val() === '02') {
                ela_form += ' + Extra Large Mouse Cursor Green';
            }
            if($j('#PARCC_ELA_Color_Contrast').val() === '03') {
                ela_form += ' + Extra Large Mouse Cursor Red';
            }
            if($j('#PARCC_ELA_Color_Contrast').val() === '04') {
                ela_form += ' + Extra Large Mouse Cursor White';
            }
            if($j('#PARCC_ELA_Color_Contrast').val() === '05') {
                ela_form += ' + Extra Large Mouse Cursor Yellow';
            }
        }
    }
    // Math
    if(!$j('#math_accommodations').is(':checked')) {
        if($j('#PARCC_Math_Test_Format').val() === 'P'){
            math_form = 'Paper Regular';
        }
    }
    else {
        if($j('#PARCC_Math_Test_Format').val() === 'P') {
            if($j('#PARCC_Math_Translate_Spa_yes').is(':checked')){
                math_form = 'Paper Spanish';
            } else 
            if($j('#PARCC_Math_Braill_W_Graphic_yes').is(':checked')){
                math_form = 'Paper Braille';
            } else 
            if($j('#PARCC_Math_Large_Print_yes').is(':checked')){
                math_form = 'Paper Large Print';
            } else {
                math_form = 'Paper Regular';
            }
        } else {
            if($j('#PARCC_Math_Translate_Spa_yes').is(':checked')){
                math_form = 'Online Spanish (w/TTS)';
            } else 
            if($j('#PARCC_Math_sign_language_yes').is(':checked')){
                math_form = 'Online Accommodated - Sign Language';
            } else 
            if($j('#PARCC_Math_Screen_Read_App').val() || $j('#PARCC_Math_Braille_Response_yes').is(':checked')){
                math_form = 'Online Accommodated - AT/Screen Reader';
            } else 
            if($j('#PARCC_Math_Human_Reader').val() || $j('#IAR_Math_extensions_yes').is(':checked')){
                math_form = 'Online Accommodated - Bundle';
            }

            if($j('#PARCC_Math_Color_Contrast').val() === '01') {
                math_form += ' + Extra Large Mouse Cursor Black';
            }
            if($j('#PARCC_Math_Color_Contrast').val() === '02') {
                math_form += ' + Extra Large Mouse Cursor Green';
            }
            if($j('#PARCC_Math_Color_Contrast').val() === '03') {
                math_form += ' + Extra Large Mouse Cursor Red';
            }
            if($j('#PARCC_Math_Color_Contrast').val() === '04') {
                math_form += ' + Extra Large Mouse Cursor White';
            }
            if($j('#PARCC_Math_Color_Contrast').val() === '05') {
                math_form += ' + Extra Large Mouse Cursor Yellow';
            }
            if($j('#PARCC_Math_Calc_Device_2').val() === '06') {
                math_form += ' + Online Calculator Ti-Scientific Add On';
            }
            if($j('#PARCC_Math_Calc_Device_2').val() === '05') {
                math_form += ' + Online Calculator Four Function Add On';
            }
        }
    }
    // Science
    if(!$j('#science_accommodations').is(':checked')) {
        if($j('#IAR_Sci_Paper_Trans').val() === '02'){
            science_form = 'Paper Regular';
        }
    }
    else {
        if($j('#IAR_Sci_Paper_Trans').val() === '02') {
            if($j('#IAR_SCI_spanish_yes').is(':checked')){
                math_form = 'Paper Spanish';
            } else 
            if($j('#IAR_Sci_Tactile_Graphics_yes').is(':checked')){
                science_form = 'Paper Braille';
            } else 
            if($j('#IAR_Sci_Large_Print_yes').is(':checked')){
                science_form = 'Paper Large Print';
            } else {
                science_form = 'Paper Regular';
            }
        } else {
            if($j('#IAR_SCI_spanish_yes').is(':checked')){
                science_form = 'Online Spanish (w/TTS)';
            } else 
            if($j('#IAR_SCI_sign_language_yes').is(':checked')){
                science_form = 'Online Accommodated - Sign Language';
            } else 
            if($j('#IAR_Sci_Assistive_Tech').val() || $j('#IAR_Sci_Braille_Response_yes').is(':checked')){
                science_form = 'Online Accommodated - AT/Screen Reader';
            } else 
            if($j('#IAR_Sci_Human_Reader').val()){
                science_form = 'Online Accommodated - Bundle';
            }

            if($j('#IAR_SCI_extensions_yes').is(':checked')) {
                science_form += ' + Speech to Text and Word Prediction';
            }
            if($j('#IAR_Sci_Color_Contrast').val() === '01') {
                science_form += ' + Extra Large Mouse Cursor Black';
            }
            if($j('#IAR_Sci_Color_Contrast').val() === '02') {
                science_form += ' + Extra Large Mouse Cursor Green';
            }
            if($j('#IAR_Sci_Color_Contrast').val() === '03') {
                science_form += ' + Extra Large Mouse Cursor Red';
            }
            if($j('#IAR_Sci_Color_Contrast').val() === '04') {
                science_form += ' + Extra Large Mouse Cursor White';
            }
            if($j('#IAR_Sci_Color_Contrast').val() === '05') {
                science_form += ' + Extra Large Mouse Cursor Yellow';
            }
        }
    }
    $j('#ela_form_message').html(ela_form);
    $j('#math_form_message').html(math_form);
    $j('#science_form_message').html(science_form);
}

function PARCCvalAll() {
    $j('.parccVal').each(function () {
        validateElement($j(this));
    });
    return "";
}
function tableStripe() {
    $j('#myform table tr:visible:even td').css("background-color", "white");
    $j('#myform table tr:visible:odd td').css("background-color", "#eee");
}

// *** start PS validation

var iep_504 = "";
if ($j('.il_iep:contains("yes")').length > 0 || $j('.il_504:contains("yes")').length > 0) {
    iep_504 = "yes"
} else {
    iep_504 = "no"
}

var lep_dual = "";
if ($j('.il_lep:contains("yes")').length > 0 || $j('.dual_lang:contains("yes")').length > 0) {
    lep_dual = "yes"
} else {
    lep_dual = "no"
}

// 25-26 PS validation
// ela
function ela_iep_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_ELA_Test_Format').val() !== 'P' || iep_504 === "no")) {
        return "Requires ELA Test Format be paper<br>and IEP/504";
    }
}
function ela_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_ELA_Test_Format').val() !== 'P')) {
        return "Requires ELA Test Format be paper";
    }
}
function ela_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_ELA_Test_Format').val() == 'P' || iep_504 === "no")) {
        return "Requires ELA Test Format be online<br>and IEP/504";
    }
}
function ela_el_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_ELA_Test_Format').val() == 'P' || (iep_504 === "no" && lep_dual === 'no'))) {
        return "Requires ELA Test Format be online<br>and IEP/504 or LEP";
    }
}
function ela_iep_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && ($j('#PARCC_ELA_Test_Format').val() == 'P' || iep_504 === "no")) {
        return "Requires ELA Test Format be online<br>and IEP/504";
    }
}
function ela_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && ($j('#PARCC_ELA_Test_Format').val() == 'P')) {
        return "Requires ELA Test Format be online";
    }
}
// math
function math_iep_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_Math_Test_Format').val() !== 'P' || iep_504 === "no")) {
        return "Requires Math Test Format be paper<br>and IEP/504";
    }
}
function math_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_Math_Test_Format').val() !== 'P')) {
        return "Requires Math Test Format be paper";
    }
}
function math_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_Math_Test_Format').val() == 'P' || iep_504 === "no")) {
        return "Requires Math Test Format be online<br>and IEP/504";
    }
}
function math_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_Math_Test_Format').val() == 'P')) {
        return "Requires Math Test Format be online";
    }
}
function math_el_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#PARCC_Math_Test_Format').val() == 'P' || (iep_504 === "no" && lep_dual === 'no'))) {
        return "Requires Math Test Format be online<br>and IEP/504 or LEP";
    }
}
function math_spanish_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && $j('#PARCC_Math_Test_Format').val() == 'P' && (iep_504 === "no" || lep_dual === 'no')) {
        return "Spanish paper format requires<br>Both LEP and IEP/504";
    } else if ($j(jQueryInput).is(':checked') && $j('#PARCC_Math_Test_Format').val() != 'P' && (lep_dual === 'no')) {
        return "Spanish online format requires LEP";
    }
}
function math_iep_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && ($j('#PARCC_Math_Test_Format').val() == 'P' || iep_504 === "no")) {
        return "Requires Math Test Format be online<br>and IEP/504";
    }
}
function math_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && ($j('#PARCC_Math_Test_Format').val() == 'P')) {
        return "Requires Math Test Format be online";
    }
}
function calculator(jQueryInput) {
    var stugrade = String($j('.stugrade').text().trim());
    if ($j(jQueryInput).val() === '01' && (iep_504 === "no" || $j('#PARCC_Math_Test_Format').val() !== 'P')) {
        return "Calculation Device and Mathematics Tool<br>Requires Math Test Format be paper<br>and IEP/504";
    }
    if ($j(jQueryInput).val() === '02' && ($j('#PARCC_Math_Test_Format').val() == 'P')) {
        return "Handheld Calculator<br>Requires Math Test Format be online";
    }
    if ($j(jQueryInput).val() === '05' && ($j('#PARCC_Math_Test_Format').val() == 'P' || iep_504 === "no" || stugrade == '8')) {
        return "Online Calculator - Four Function<br>Requires Math Test Format be online<br>Grades 3-7<br>and IEP/504";
    }
    if ($j(jQueryInput).val() === '06' && ($j('#PARCC_Math_Test_Format').val() == 'P' || iep_504 === "no" || stugrade != '8')) {
        return "Online Calculator - TI-30 Scientific<br>Requires Math Test Format be online<br>Grade 8<br>and IEP/504";
    }
}

// science
function science_iep_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#IAR_Sci_Paper_Trans').val() != '02' || iep_504 === "no")) {
        return "Requires Science Test Format be paper<br>and IEP/504";
    }
}
function science_paper_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#IAR_Sci_Paper_Trans').val() != '02')) {
        return "Requires Science Test Format be paper";
    }
}
function science_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && ($j('#IAR_Sci_Paper_Trans').val() == '02')) {
        return "Requires Science Test Format be online";
    }
}
function science_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && $j(iep_504 === "no")) {
        return "Requires IEP/504";
    }
}
function science_el_iep_online_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && 
    (
        $j('#IAR_Sci_Paper_Trans').val() == '02' || (iep_504 === "no" && lep_dual === 'no')
    )) {
        return "Requires Science Test Format be online<br>and IEP/504 or LEP";
    }
}
function science_spanish_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && $j('#IAR_Sci_Paper_Trans').val() == '02' && (iep_504 === "no" || lep_dual === 'no')) {
        return "Spanish paper format requires<br>Both LEP and IEP/504";
    } else if ($j(jQueryInput).is(':checked') && $j('#IAR_Sci_Paper_Trans').val() != '02' && (lep_dual === 'no')) {
        return "Spanish online format requires LEP";
    }
}
function science_iep_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && iep_504 === "no") {
        return "Requires IEP/504";
    }
}
function science_online_select(jQueryInput) {
    if ($j(jQueryInput).val() && ($j('#IAR_Sci_Paper_Trans').val() == '02')) {
        return "Requires Science Test Format be online";
    }
}

// all
function iep_paper_select(jQueryInput) {
    if (($j(jQueryInput).val() === 'P' || $j(jQueryInput).val() === '02') && (iep_504 === "no")) {
        return "Requires IEP/504";
    }
}
function iep_both_select(jQueryInput) {
    if ($j(jQueryInput).val() && (iep_504 === "no")) {
        return "Requires IEP/504";
    }
}
function el_both_select(jQueryInput) {
    if ($j(jQueryInput).val() && (lep_dual === 'no')) {
        return "Requires LEP";
    }
}
function el_iep_both_select(jQueryInput) {
    if ($j(jQueryInput).val() && (lep_dual === 'no' && iep_504 === "no")) {
        return "Requires LEP or IEP/504";
    }
}
function iep_both_radio(jQueryInput) {
    if ($j(jQueryInput).is(':checked') && (iep_504 === "no")) {
        return "Requires IEP/504";
    }
}
// end new validation

// runs at page submit to clear fields if their containing div is hidden
function clear_hidden() {
    if (!$j("#ela_accommodations").is(':checked')) {
        $j("#ela_div").children().find("input,select").each(function () {
            $j(this).val('');
        });
    }
    if (!$j("#math_accommodations").is(':checked')) {
        $j("#math_div").children().find("input,select").each(function () {
            $j(this).val('');
        });
    }
    if (!$j("#science_accommodations").is(':checked')) {
        $j("#science_div").children().find("input,select").each(function () {
            $j(this).val('');
        });
    }
}
$j('#myform').submit(clear_hidden);

// run functions on input change
var watchedFields =
    '#PARCC_ELA_Test_Format, #PARCC_Math_Test_Format, #IAR_Sci_Paper_Trans, ' +
    '#ela_div input, #math_div input, #science_div input, ' +
    '#ela_div select, #math_div select, #science_div select';

$j(document).on('change', watchedFields, function () {
    PARCCvalAll();
    determineForm();
});

// runs at page load
$j(function () {

    // when ela/math/science is checked unchecked
    $j("#ela_accommodations").on('change', function () {
        if ($j(this).is(':checked')) {
            $j('#ela_div').show();
        }
        else if ($j(this).prop('checked') === false && $j('#ela_div .error-message').is(":visible")) {
            $j('#ela_accommodations').prop('checked', true);
            alert('Please correct errors in ELA accommodations before unchecking the accommodations checkbox and submitting');
        }
        else {
            $j('#ela_div').hide();
        }
        determineForm();
    });
    $j("#math_accommodations").on('change', function () {
        if ($j(this).is(':checked')) {
            $j('#math_div').show();
        }
        else if ($j(this).prop('checked') === false && $j('#math_div .error-message').is(":visible")) {
            $j('#math_accommodations').prop('checked', true);
            alert('Please correct errors in math accommodations before unchecking the accommodations checkbox and submitting');
        }
        else {
            $j('#math_div').hide();
        }
        determineForm();
    });
    $j("#science_accommodations").on('change', function () {
        if ($j(this).is(':checked')) {
            $j('#science_div').show();
        }
        else if ($j(this).prop('checked') === false && $j('#science_div .error-message').is(":visible")) {
            $j('#science_accommodations').prop('checked', true);
            alert('Please correct errors in science accommodations before unchecking the accommodations checkbox and submitting');
        }
        else {
            $j('#science_div').hide();
        }
        determineForm();
    });
    $j("#ela_accommodations, #math_accommodations, #science_accommodations").trigger('change');
    setTimeout(function () {
        $j("#PARCC_ELA_DirRead_StuNtLng, #PARCC_Math_DirRead_StuNtLng, #IAR_Sci_StuNative_Lang").trigger('change');
    }, 1000);

    // highlight obsolete values
    $j("option:selected:contains('obsolete')").closest("select").after('<div class="alertError">This is an obsolete value and should be changed</div>');

    PARCCvalAll();
    determineForm();

}); // end on ready
